/* InterfaceKit C++ Example
 * Demonstrates how the handle events in C++ classes without the need for Globals, etc.
 */
#include "stdafx.h"
#include "..\..\..\phidget21.h"
#include <iostream>
using namespace std;

int __stdcall SensorChangeHandler(CPhidgetInterfaceKitHandle IFK, void *usrptr, int Index, int Value);

//Class definition
class PhidgetClass {
    CPhidgetInterfaceKitHandle ifkit;
  public:
	void sensorChanged(int index, int value);
    void start();
};

//create and open the Phidget
void PhidgetClass::start () {
	CPhidgetInterfaceKit_create(&ifkit);
	//Set up the sensor change function, sending it a reference to this object.
	CPhidgetInterfaceKit_set_OnSensorChange_Handler (ifkit, SensorChangeHandler, this);
	CPhidget_open((CPhidgetHandle)ifkit, -1);
}

//C callback
int __stdcall SensorChangeHandler(CPhidgetInterfaceKitHandle IFK, void *usrptr, int Index, int Value)
{
	//Retrieve the class reference and call it's sensorChanged method
	PhidgetClass *obj = (PhidgetClass *)usrptr;
	obj->sensorChanged(Index, Value);
	return 0;
}

void PhidgetClass::sensorChanged (int index, int value) {
	cout << "Sensor Change: " << index << ": " << value << "\n";
}

int main () {
	PhidgetClass obj;
	obj.start();

	//loop forever while sensor events come in.
	while(1);

	return 0;
}
